//
//  MCMMessage.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 09-10-22.
//  Copyright 2009 Marketcircle Inc. All rights reserved.
//

#import <CoreData/CoreData.h>


@class MCMAccount;

@interface MCMMessage : NSManagedObject {

}

- (NSDate *)created;
- (void)setCreated:(NSDate *)value;
//- (BOOL)validateCreated:(id *)valueRef error:(NSError **)outError;

- (NSNumber *)priority;
- (void)setPriority:(NSNumber *)value;
//- (BOOL)validatePriority:(id *)valueRef error:(NSError **)outError;

- (NSDate *)received;
- (void)setReceived:(NSDate *)value;
//- (BOOL)validateReceived:(id *)valueRef error:(NSError **)outError;

- (NSDate *)sent;
- (void)setSent:(NSDate *)value;
//- (BOOL)validateSent:(id *)valueRef error:(NSError **)outError;

- (NSString *)subject;
- (void)setSubject:(NSString *)value;
//- (BOOL)validateSubject:(id *)valueRef error:(NSError **)outError;

- (NSNumber *)unread;
- (void)setUnread:(NSNumber *)value;
//- (BOOL)validateUnread:(id *)valueRef error:(NSError **)outError;

// Access to-many relationship via -[NSObject mutableSetValueForKey:]
- (void)addAttachmentsObject:(NSManagedObject *)value;
- (void)removeAttachmentsObject:(NSManagedObject *)value;

- (MCMAccount *)receiver;
- (void)setReceiver:(MCMAccount *)value;
//- (BOOL)validateReceiver:(id *)valueRef error:(NSError **)outError;

- (MCMAccount *)sender;
- (void)setSender:(MCMAccount *)value;
//- (BOOL)validateSender:(id *)valueRef error:(NSError **)outError;

// the first string attachment
- (NSString *)body;
- (void)setBody:(NSString *)value;
//- (BOOL)validateBody:(id *)valueRef error:(NSError **)outError;

- (BOOL)read;
- (void)setRead:(BOOL)flag;
- (void)setRead;
- (void)setUnread;

- (BOOL)expired;
- (void)setExpired:(BOOL)expired;

- (NSArray *)orderedAttachments;
- (NSArray *)convertedAttachments;
- (void)deleteAttachments;

// This compares all the attachments (converted) for equality; so it could be expensive
- (BOOL)isEqualToMessage:(MCMMessage *)message;

// Attachments can be any class that supports NSCoder or can be represented as a property list; property lists will be attached as text, all else as NSData
+ (MCMMessage *)sendMessageFrom:(MCMAccount *)sender to:(MCMAccount *)receiver subject:(NSString *)subject body:(NSString *)body attachments:(NSArray *)attachments;
+ (MCMMessage *)sendMessageFrom:(MCMAccount *)sender to:(MCMAccount *)receiver subject:(NSString *)subject body:(NSString *)body;

+ (MCMMessage *)sendMessageTo:(NSString *)receiver subject:(NSString *)subject body:(NSString *)body attachments:(NSArray *)attachments;
+ (MCMMessage *)sendMessageTo:(NSString *)receiver subject:(NSString *)subject body:(NSString *)body;
+ (MCMMessage *)sendMessage:(NSString *)body to:(NSString *)receiver;

@end
